﻿
/****************************************************************************/
/*Copyright (c) 2011, Florent DEVILLE.                                      */
/*All rights reserved.                                                      */
/*                                                                          */
/*Redistribution and use in source and binary forms, with or without        */
/*modification, are permitted provided that the following conditions        */
/*are met:                                                                  */
/*                                                                          */
/* - Redistributions of source code must retain the above copyright         */
/*notice, this list of conditions and the following disclaimer.             */
/* - Redistributions in binary form must reproduce the above                */
/*copyright notice, this list of conditions and the following               */
/*disclaimer in the documentation and/or other materials provided           */
/*with the distribution.                                                    */
/* - The names of its contributors cannot be used to endorse or promote     */
/*products derived from this software without specific prior written        */
/*permission.                                                               */
/* - The source code cannot be used for commercial purposes without         */
/*its contributors' permission.                                             */
/*                                                                          */
/*THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT         */
/*LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS         */
/*FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE            */
/*COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,       */
/*INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,      */
/*BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;          */
/*LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER          */
/*CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT        */
/*LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN         */
/*ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/*POSSIBILITY OF SUCH DAMAGE.                                               */
/****************************************************************************/

using Microsoft.Xna.Framework;

using GE.Visualisation;

namespace GE.Gui
{
    /// <summary>
    /// A progress bar widget.
    /// </summary>
    class WProgressBar : Widget
    {
        /// <summary>
        /// Background graphic ID.
        /// </summary>
        private int m_bgGid;

        /// <summary>
        /// Foreground graphic ID.
        /// </summary>
        private int m_fgGid;

        /// <summary>
        /// Background asset.
        /// </summary>
        private string m_bgAsset;

        /// <summary>
        /// Foreground asset.
        /// </summary>
        private string m_fgAsset;

        /// <summary>
        /// Ratio.
        /// </summary>
        private float m_ratio;

        /// <summary>
        /// Position.
        /// </summary>
        private Vector2 m_position;

        /// <summary>
        /// relative position of the foregound.
        /// </summary>
        private Vector2 m_offset;

        /// <summary>
        /// Position.
        /// </summary>
        public Vector2 Position
        {
            set
            {
                m_position.X = (int)value.X;
                m_position.Y = (int)value.Y;
            }
        }

        /// <summary>
        /// Ratio.
        /// </summary>
        public float Ratio
        {
            get
            {
                return m_ratio;
            }
            set
            {
                m_ratio = value;
            }
        }

        public string Foreground
        {
            set
            {
                m_fgAsset = value;
                reload(m_bgAsset, m_fgAsset);
            }
        }

        /// <summary>
        /// Contructor.
        /// </summary>
        /// <param name="background">background</param>
        /// <param name="foreground">foregound</param>
        /// <param name="position">position</param>
        /// <param name="offset">offset of the background</param>
        public WProgressBar(string background, string foreground, Vector2 position, Vector2 offset)
        {
            m_position = position;
            m_offset = offset;
            m_ratio = 0f;
            m_bgAsset = background;
            m_fgAsset = foreground;
            reload(background, foreground);
        }

        /// <summary>
        /// Reload widget.
        /// </summary>
        /// <param name="background">background</param>
        /// <param name="foreground">foregound</param>
        private void reload(string background, string foreground)
        {
            m_bgGid = Gui.Instance.loadTexture(background);
            m_fgGid = Gui.Instance.loadTexture(foreground);
            return;
        }

        /// <summary>
        /// Update the widget.
        /// </summary>
        public override void update()
        {
            base.update();
        }

        /// <summary>
        /// Render the widget.
        /// </summary>
        /// <param name="offset">position offset</param>
        public override void render(Vector2 offset)
        {
            base.render(offset);
            Visu.Instance.displayTexture(m_bgGid, m_position + offset);
            Visu.Instance.displayTexture(m_fgGid, m_position + offset + m_offset, Vector2.Zero,
                0f, new Vector2(m_ratio, 1f));
        }
    }
}
